<?php
require 'db.php'; // Ensure this contains the $conn object for database connection

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $shippingId = $_POST['shippingId'];

    if (!isset($shippingId)) {
        echo json_encode(['status' => 'error', 'message' => 'Shipping ID is required.']);
        exit;
    }

    try {
        // Set mode to 0 for all records
        $resetQuery = "UPDATE shippingmethod SET mode = 0";
        $conn->query($resetQuery);

        // Set mode to 1 for the specific shippingId
        $updateQuery = "UPDATE shippingmethod SET mode = 1 WHERE shippingid = ?";
        $stmt = $conn->prepare($updateQuery);
        $stmt->bind_param('i', $shippingId);
        $stmt->execute();

        if ($stmt->affected_rows > 0) {
            echo json_encode(['status' => 'success', 'message' => 'Toggle updated successfully.']);
        } else {
            echo json_encode(['status' => 'error', 'message' => 'Failed to update the toggle.']);
        }

        $stmt->close();
    } catch (Exception $e) {
        echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
    }
} else {
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method.']);
}
?>
